#include <Servo.h>  
Servo myservoA;  
Servo myservoB;
Servo myservoC;
Servo myservoD;
Servo myservoE;
Servo myservoF;
int i,pos,myspeed;
int sea,seb,sec,sed,see,sef;
static int v=0;

String mycommand="";  //Захват команд порта  #auto：Автоматический режим   #com：Управление последовательным портом     #stop：Останов
static int mycomflag=2; // #auto：2 запускать автоматически  , #com： 1  управление с компьютера   #stop：0 останов   

void myprint()
{
   sea=myservoA.read();
   seb=myservoB.read();
   sec=myservoC.read();
   sed=myservoD.read();
   see=myservoE.read();
   sef=myservoF.read();
   
   Serial.print("A=");
   Serial.print(sea);
   Serial.print(" B=");
   Serial.print(seb);
   Serial.print(" C=");
   Serial.print(sec);
   Serial.print(" D=");
   Serial.print(sed);
   Serial.print(" E=");
   Serial.print(see);
   Serial.print(" F=");
   Serial.println(sef);   
}

void myservosetup()  //перевести сервоприводы в режим ожидания
{
   sea=myservoA.read();
   seb=myservoB.read();
   sec=myservoC.read();
   sed=myservoD.read();
   see=myservoE.read();
   sef=myservoF.read();
   
   myspeed=500;
   for(pos=0;pos<=myspeed;pos+=1)
   {
    myservoA.write(int(map(pos,1,myspeed,sea,66)));
    myservoB.write(int(map(pos,1,myspeed,seb,90)));
    myservoC.write(int(map(pos,1,myspeed,sec,50)));
    myservoD.write(int(map(pos,1,myspeed,sed,90)));
    myservoE.write(int(map(pos,1,myspeed,see,120)));
    myservoF.write(int(map(pos,1,myspeed,sef,90)));    
    delay(1);
   }
}

void setup() 
{  
  Serial.begin(9600,SERIAL_8N1);
 
  mycomflag=2; // По умолчанию режим работы манипулятора 2: автоматический режим
  myservoA.attach(3);  // Контроль поворота（A）Порт 3
  myservoB.attach(5); // Правый поперечный сервопривод（B）Порт 5
  myservoC.attach(6); // Левый поперечный сервопривод（C）Порт 6
  myservoD.attach(9); // Продольный сервопривод（D）Порт 9
  myservoE.attach(10); // Сервопривод наклона лапки（E）Порт 10
  myservoF.attach(11); // Сервопривод поворота лапки（F）Порт 11
  
  myservoA.write(66);
  myservoB.write(90);
  myservoC.write(55);
  myservoD.write(90);
  myservoE.write(120);
  myservoF.write(90);
}

void loop() 
{ 
  while (Serial.available() > 0)  
    {
        mycommand += char(Serial.read());
        delay(2);
    }
    if (mycommand.length() > 0)
    {
        if(mycommand=="#auto")
        {
          mycomflag=2;
          Serial.println("auto station");
          mycommand="";
        }
        if(mycommand=="#com")
        {
          mycomflag=1;
          Serial.println("computer control station");
          mycommand="";
          myservosetup();
        }
        if(mycommand=="#stop")
        {
          mycomflag=0;
          Serial.println("stop station");
          mycommand="";
        }        
    }  
  
  if(mycomflag==1)  //Если включено управление с компьютера [1]
  {      
 
   for(int m=0;m<mycommand.length();m++) // Чтение данных
  {
    char ch = mycommand[m];   //读取串口数据
    switch(ch)
    {
      case '0'...'9':
      v = v*10 + ch - '0';   //字符转换成十进制
      break;
      
      case 'a':   //Если после идет "а", это указывает на 1ый сервопривод
      if(v >= 5 || v <= 175 ) myservoA.write(v); //диапазон установки угла поворота от 0 градусов до 180
      v = 0;
      myprint();
      break;

      case 'b':   //Если после идет "b", это указывает на 2ый сервопривод
      myservoB.write(v);   //диапазон установки угла поворота от 0 градусов до 180
      v = 0;
      myprint();
      break;
      
      case 'c':   
      if(v >= 20 ) myservoC.write(v);   
      v = 0;
      myprint();
      break;

      case 'd':  
      myservoD.write(v);   
      v = 0;
      myprint();
      break;

      case 'e':  
      myservoE.write(v);   
      v = 0;
      myprint();
      break;
      
      case 'f':  
      myservoF.write(v);   
      myprint();
      v = 0;
      break;
    }
   
    }  
   mycommand="";   
   
  }  // end if(mycomflag=2)
  
  if(mycomflag==2)  //Если автоматический режим работы [2]
  {    
   delay(3000); 
   //Serial.println("auto station"); 
   myservosetup();
   myspeed=500;
    for(pos = 0; pos <=myspeed; pos += 1)  
  {                                
    myservoA.write(int(map(pos,1,myspeed,66,90))); // Вращение от 66 градусов до 90 градусов (угол можно менять)
    myservoB.write(int(map(pos,1,myspeed,90,70))); // Вращение от 90 градусов до 40 градусов (угол может быть изменен)
    delay(1);                       
  }
   delay(1000);
   myspeed=500;
  for(pos = 0; pos <=myspeed; pos += 1)  
  {                                
    myservoC.write(int(map(pos,1,myspeed,50,65))); // 
    myservoD.write(int(map(pos,1,myspeed,90,170))); //
    myservoE.write(int(map(pos,1,myspeed,90,5))); 
    delay(1);                       
   }
  myspeed=1000;
  for(pos = 0; pos <=myspeed; pos += 1)  
  {                                
    myservoB.write(int(map(pos,1,myspeed,70,90))); // 
    myservoC.write(int(map(pos,1,myspeed,65,50))); //
    delay(1);                       
   }
   myspeed=500;
  for(pos = 0; pos <=myspeed; pos += 1)  
  {                                
    myservoC.write(int(map(pos,1,myspeed,50,45))); // 
    myservoD.write(int(map(pos,1,myspeed,170,90))); //
    myservoE.write(int(map(pos,1,myspeed,5,50)));
    myservoF.write(int(map(pos,1,myspeed,90,40)));
    delay(1);                       
   }
   myspeed=1000;
  for(pos = 0; pos <=myspeed; pos += 1)  
  {                                
    myservoA.write(int(map(pos,1,myspeed,90,140))); // 
    myservoF.write(int(map(pos,1,myspeed,40,130)));    
    delay(1);                       
   }  
    myspeed=500;
    for(pos = 0; pos <=myspeed; pos += 1)  
  {                                
    myservoA.write(int(map(pos,1,myspeed,140,90))); // 
    myservoC.write(int(map(pos,1,myspeed,45,50))); // 
    myservoB.write(int(map(pos,1,myspeed,90,70))); //
    myservoE.write(int(map(pos,1,myspeed,50,120))); //
    delay(1);                       
  } 
  }
  
  if(mycomflag==0) //Состояние останова [0]
  {
   myservosetup();
  }
}
